/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.kintai.action.AttendanceListAction;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.vo.AttendanceStartCardVo;

public class AttendanceStartCardAction extends AttendanceTotalAction {

	// R}h
	public static final String CMD_START_CARD_SHOW		= "K1100";
	public static final String CMD_START_CARD_SELECT		= "K1101";
	private static final String CMD_START_CARD_REGIST		= "K1102";
	private static final String CMD_START_CARD_DELETE		= "K1103";

	/**
	 * RXgN^
	 */
	public AttendanceStartCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		AttendanceStartCardVo vo;
		vo = (AttendanceStartCardVo)getStoredVo(CommonConst.VO_ATTENDANCE_START_CARD);
		if (vo == null) {
			vo = new AttendanceStartCardVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_ATTENDANCE_START_CARD, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DTO̎擾
		MSyukkinboDto dto;
		Object objDto = session.getAttribute(MospConst.ATT_DTO);
		dto = objDto instanceof MSyukkinboDto ? (MSyukkinboDto)objDto : null;
		// DBRlNV擾
		getConnection();
		// [U[擾
		getInfo(user.getUserId());
		// Ζ`ԃv_E
		vo.aryPltWorkType = getWorkTypeArrayWithWeekHoliday();
		// oΎx敪v_E
		vo.aryPltHalfHoliday = getMosPCodeArray(CommonConst.TID_HALF_HOLIDAY_TYPE);
		// xo敪v_E
		vo.aryPltWorkOnHoliday = getMosPCodeArray(CommonConst.TID_WORK_ON_HOLIDAY_TYPE);
		// xRv_E
		vo.aryPltLateReason = getReasonCodeArray(CommonConst.TID_LATE_REASON);
		// xؖv_E
		vo.aryPltLateCertificate = getMosPCodeArray(CommonConst.TID_LATE_CERTIFICATE);
		// ΑӊǗR}h
		setSubTitleMenu(vo);
		// R}h̏
		if (cmd.equals(CMD_START_CARD_SHOW)) {
			// \ڂ̏
			vo.initFields();
			// \Ao^̏
			setAttendanceInfo(vo);
			// o΃{^ɃR}hZbg
			vo.setCmdStartButton(CMD_START_CARD_SHOW);
			// xɃ{^ɃR}hZbg
			vo.setCmdHolidayButton(AttendanceHolidayCardAction.CMD_HOLIDAY_CARD_SHOW);
			// \[hZbg
			setMode(vo, dto);
		} else if (cmd.equals(CMD_START_CARD_SELECT)) {
			vo.setParams(request);
			// oΌ
			dto = searchAttendance(vo);
			// o΃{^ɃR}hZbg
			vo.setCmdStartButton(CMD_START_CARD_SELECT);
			// ދ΃{^ɃR}hZbg
			vo.setCmdQuitButton(AttendanceQuitCardAction.CMD_QUIT_CARD_SHOW);
			// MenuVoɑIR}hZbg
			vo.setHidSelectCmd(CMD_START_CARD_SELECT);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_START_CARD_REGIST)) {
			vo.setParams(request);
			// o^
			dto = registAttendance(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
			// Αӈꗗ֑J
			setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
			// bZ[Wݒ
			request.setAttribute(MospConst.ATT_MESSAGE, MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		} else if (cmd.equals(CMD_START_CARD_DELETE)) {
			vo.setParams(request);
			// 폜
			dto = delete(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
			// Αӈꗗ֑J
			setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
			// bZ[Wݒ
			request.setAttribute(MospConst.ATT_MESSAGE, MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
		// ČpMenuVo̕ۑ
		setStoreAttendanceMenuVo(vo);
	}

	/**
	 * oΌ
	 * @param vo AttendanceCardVoCX^X
	 * @return 擾AttendanceCardDtoCX^X
	 * @throws Exception
	 */
	private MSyukkinboDto searchAttendance(AttendanceStartCardVo vo) throws Exception {
		// Αӌ
		MSyukkinboDto dto = getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate());
		// VOɏݒ
		vo.setFields(dto);
		// \[h̃Zbg
		setMode(vo, dto);
		return dto;
	}

	/**
	 * oΓo^
	 * @param vo  VoCX^X
	 * @param dto DtoCX^X
	 * @return o^Ď擾DtoCX^X
	 * @throws Exception
	 */
	private MSyukkinboDto registAttendance(
			AttendanceStartCardVo vo,
			MSyukkinboDto dto
	) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// syukkinboDao
		prepareMSyukkinboDao();
		// Αӌ
		MSyukkinboDto mSyukkinboDto = new MSyukkinboDto();
		if (dto == null) {
			// INSERT(ZbVۑDTO݂Ȃꍇ)
			// Tx̏ꍇ
			if (isWeekHoliday(vo.getPltWorkType())) {
				vo.setWeekHolidayDtoFields(mSyukkinboDto);
			} else {
				vo.setDtoFields(mSyukkinboDto);
			}
			mSyukkinboDto.setSyozoku(mKihon.getSCode());
			// vZ
			runAutoStartCalc(vo, mSyukkinboDto);
			// ݃`FbN
			chkDuplicate(getSyukkinboInfo(mSyukkinboDto.getKCode(), mSyukkinboDto.getHizuke()), vo);
			// Tx̏ꍇ
			if (isWeekHoliday(vo.getPltWorkType())) {
				// o^
				syukkinboDao.insert(mSyukkinboDto);
			} else {
				// o^io΍ڂ̂݁j
				syukkinboDao.insertStart(mSyukkinboDto);
			}
		} else {
			// Fς݂̏ꍇ̓bZ[W\Ao^s
			if (isApproved(dto)) {
				// bZ[Wݒ
				request.setAttribute(MospConst.ATT_MESSAGE, 
						MospUtility.getMessage(msg, CommonConst.MSG_ALREADY_APPROVED, 
								getMessageDate(vo.getHidYear(), vo.getHidMonth(), vo.getHidDay())
						)
				);
			} else {
				// UPDATE(ZbVۑDTO݂ꍇ)
				mSyukkinboDto = dto;
				vo.setDtoFields(mSyukkinboDto);
				// vZ
				runAutoStartCalc(vo, mSyukkinboDto);
				// rmF
				chkExclusive(mSyukkinboDto, getSyukkinboInfo(mSyukkinboDto.getKCode(), mSyukkinboDto.getHizuke(), true), vo);
				// XVio΍ڂ̂݁j
				syukkinboDao.updateStart(mSyukkinboDto);
			}
		}
		// DTO̍Ď擾
		MSyukkinboDto retDto = getSyukkinboInfo(mSyukkinboDto.getKCode(), mSyukkinboDto.getHizuke());
		chkUpdate(retDto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

	/**
	 * o΍ڍ폜
	 * @param dto
	 * @throws Exception
	 */
	private MSyukkinboDto delete(AttendanceStartCardVo vo, MSyukkinboDto dto) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// oΕpDAO 
		prepareMSyukkinboDao();
		// f[^݊mF
		chkExist(dto);
		// Fς݂̏ꍇ̓bZ[W\A폜s
		if (isApproved(dto)) {
			// bZ[Wݒ
			request.setAttribute(MospConst.ATT_MESSAGE, 
					MospUtility.getMessage(msg, CommonConst.MSG_ALREADY_APPROVED, 
							getMessageDate(vo.getHidYear(), vo.getHidMonth(), vo.getHidDay())));
		} else {
			// 폜
			syukkinboDao.delete(dto);
		}
		// DTO̍Ď擾
		MSyukkinboDto retDto = getSyukkinboInfo(dto.getKCode(), dto.getHizuke());
		// R~bg
		commit();
		return retDto;
	}

	/**
	 * vZ\bh
	 * @param vo
	 * @param dto
	 * @throws Exception
	 */
	private void runAutoStartCalc(AttendanceStartCardVo vo, MSyukkinboDto dto) throws Exception {
		// Ώۓ擾
		Date targetDay = util.convStringDateToDate(vo.getHidDate());
		// Αӓf[^擾
		getAttendanceDay(vo.getHidKCode(), targetDay);
		// vZtOL̂݁AΖ`ԂxԂvZ
		if (isAutoCalc) {
			// 
			late 		= 0;
			// TxȊO
			if (!isWeekHoliday(dto)) {
				// Ζ`ԂK莞擾
				getWorkTypeInfo(dto.getKinmu());
				// oΎZo
				int start = util.convStringTimeToIntegerTime(dto.getSyJikoku());
				boolean shankyukbn = isStartHalfHoliday(dto);
				boolean kyusyukbn = isWorkOnHoliday(dto);
				// o΍ڂ̌vZ
				getCalcStartTime(start, shankyukbn, kyusyukbn);
				// xԃZbg
				dto.setTiJikan(late);
			}
		}
	}

}
